/*------------------------------------------------------------------------------*
 * File Name: PBLayerList.c														*
 * Creation: 																	*
 * Purpose: A Control base class for showing a list of pages 					*
 * Copyright (c) Originlab Corp., 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Jasmine 11/29/05 QA70-8352 v8.0341 MODIFICATION_FINDCLASS					*
 *	CPY 12/2/05 rename from .h to .c and made relavent changes					*
 * Jasmine 12/25/06 SHOW_PAGE_OR_LAYER											*
 * Folger 06/20/07 CREATE_GET_INIT_RANGE_STRING									*
 * Folger 07/03/07 CLEAN_UP_GET_RANGE_STRING_CODE								*
 * Folger 07/13/07 ADD_SHOW_ITEM_TYPE_TO_SPECIFY_BROWSE_PAGE_TYPE				*
 * Folger 07/27/07 FIX_BUGS_IN_DISPLAY_IMPORT_FILE_NAME							*
 * Folger 08/03/07 ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE						*
 * Folger 11/07/07 COLUMN_HEADING_LOCALIZE										*
 * Folger 07/14/08 QA80-11840 FIX_RUNTIME_ERROR_FOR_SOME_SPECIAL_IMPORT_DATA	*
 * Kyle 07/15/08 QA80-11840 CHANGE_THE_CONTEXT_MENU_TO_LIST_EACH_AVAILABLE_ITEM	*
 * Kyle 07/15/08 QA80-11840 CHANGE_THE_SIZE_DISPLAY_FORMAT						*
 * Kyle 07/15/08 QA80-11840 OVER_LOAD_FUNCTION_GETDEFAULTSHOW					*
 * Jasmine 03/12/09 QA80-11826-P5 DEFAULT_SHOULD_SHOW_LAYER_NAME				*
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
#include "DialogEx.h"
#include "PBListBase.h"
///Kyle 07/15/08 QA80-11840 CHANGE_THE_CONTEXT_MENU_TO_LIST_EACH_AVAILABLE_ITEM
//enum {PELAYER_NAME, PELAYER_TYPE,PELAYER_SIZE, PELAYER_VIEW, PELAYER_FILENAME,PELAYER_TOTAL_COLS};
///End CHANGE_THE_CONTEXT_MENU_TO_LIST_EACH_AVAILABLE_ITEM
//------ Folger 11/07/07 COLUMN_HEADING_LOCALIZE
//#define LAYER_LIST_COL_HEADER		_L("Name|Type|Size|View|File Name")
#ifndef _CAT
#define _CAT "PELayers"
#endif
#define LAYER_LIST_COL_HEADER		_LC("Name|Type|Size|View|File Name", _CAT)
//------ End COLUMN_HEADING_LOCALIZE

//class PBLayerList : public PBListBase	///Jasmine 11/29/05 QA70-8352 v8.0341 MODIFICATION_FINDCLASS
class OC_REGISTERED PBLayerList : public PBListBase
{
	PBLayerList()
	{
		//------ Folger 11/07/07 COLUMN_HEADING_LOCALIZE
		//GetFormatStrAsArray(LAYER_LIST_COL_HEADER, m_vsColHeadings, "PELayers");
		GetFormatStrAsArray(LAYER_LIST_COL_HEADER, m_vsColHeadings, _CAT);
		//------ End COLUMN_HEADING_LOCALIZE
	}
	~PBLayerList()
	{
	}	
public:
	///Kyle 07/15/08 QA80-11840 OVER_LOAD_FUNCTION_GETDEFAULTSHOW
	virtual int	GetDefaultShow( Layer& lay, GridTreeControl* pGridTree, LPCSTR lpcszDefaultShow = NULL )
	{
		int nRow =- 1;
		string strDefaultShow( lpcszDefaultShow );
		if( strDefaultShow.IsEmpty() )
		{
			if( lay )
			{
				Page pg = lay.GetPage();
				pg.GetRangeString( strDefaultShow );
			}
		}
		if( !strDefaultShow.IsEmpty() )
		{
			string strBook, strSheet;
			okutil_get_book_sheet_info(&strBook, &strSheet, strDefaultShow);
			nRow = pGridTree->FindRow(strBook);
		}
		if(nRow < 0)
		{
			Folder fld = Project.ActiveFolder();
			strDefaultShow = fld.GetPath();

			strDefaultShow.TrimLeft('/');
			strDefaultShow.TrimRight('/');
			vector<string> vs;
			strDefaultShow.GetTokens(vs, '/');
			for( int ii = 0; ii < vs.GetSize(); ii++)
			{
				int nLevel = -1;
				while( nLevel != ii )
				{
					nRow = pGridTree->FindRow( vs[ii], 0, false, true, nRow+1 );
					nLevel = ( (-1 == nRow)? ii : pGridTree->GetLevel( nRow ) );
				}
			}
		}
		return nRow;
	}
	///End OVER_LOAD_FUNCTION_GETDEFAULTSHOW
	///Kyle 07/15/08 QA80-11840 CHANGE_THE_CONTEXT_MENU_TO_LIST_EACH_AVAILABLE_ITEM
	virtual BOOL SetShowColumns(const vector<uint>& vnShowColumns = NULL)
	{
		vector<byte> vbShowCols;
		vbShowCols.SetSize(PELAYER_TOTAL_COLS);
		vbShowCols = 1;
		m_vnShowColumns.Data(PELAYER_NAME, PELAYER_FILENAME);
		if(vnShowColumns)
			m_vnShowColumns = vnShowColumns;	
		int nSize = m_vnShowColumns.GetSize();
		for(int ii = 0; ii < nSize; ii++)
		{
			int nIndex = m_vnShowColumns[ii];
			if(PELAYER_TOTAL_COLS > nIndex)
				vbShowCols[nIndex] = 0;
		}
		///Jasmine 03/12/09 QA80-11826-P5 DEFAULT_SHOULD_SHOW_LAYER_NAME
		//vbShowCols[PELAYER_NAME] = 1;
		///End DEFAULT_SHOULD_SHOW_LAYER_NAME
		LoadHideCols(m_strDlgName, "PBLayerList", &vbShowCols);
		//vector<uint> vecIndex;
		//if(0 < m_vnShowColumns.Find(vecIndex, PELAYER_NAME))
			//m_dwCtrl |= SHOW_LAYER_NAME;//dwShowCols;
		return true;
	}
///End CHANGE_THE_CONTEXT_MENU_TO_LIST_EACH_AVAILABLE_ITEM

	//-----Folger 07/13/07 ADD_SHOW_ITEM_TYPE_TO_SPECIFY_BROWSE_PAGE_TYPE
	//void Init(int nID, WndContainer& dlg, LPCSTR lpcszDlgName )
	void Init(int nID, WndContainer& dlg, LPCSTR lpcszDlgName, int nShowItemType )
	//-----End ADD_SHOW_ITEM_TYPE_TO_SPECIFY_BROWSE_PAGE_TYPE
	{
		//-----Folger 07/13/07 ADD_SHOW_ITEM_TYPE_TO_SPECIFY_BROWSE_PAGE_TYPE
		//PBListBase::Init(nID, dlg, lpcszDlgName);
		PBListBase::Init(nID, dlg, lpcszDlgName, nShowItemType);
		//-----End ADD_SHOW_ITEM_TYPE_TO_SPECIFY_BROWSE_PAGE_TYPE
		
		m_PBBType = ITEM_IS_LAYER;
		m_strDlgName = lpcszDlgName;		///Kyle 07/15/08 QA80-11840 CHANGE_THE_CONTEXT_MENU_TO_LIST_EACH_AVAILABLE_ITEM
		
		vector<byte> vbDefaultShowCols = {0,0,1,0,0};		
		LoadHideCols(lpcszDlgName, "PBLayerList", &vbDefaultShowCols);	//Load and update the column show state

		//vector<byte> vbDefaultShowCols = {0,0,0,0,0};		
		//m_flx.Cols = PELAYER_TOTAL_COLS;
		//m_flx.FormatString = makeColHeadings();
		//LoadHideCols(lpcszDlgName, "PageListHideShowCols", &vbDefaultShowCols);
	}

	virtual int GetPBListType()
	{
		return PB_BROWSER_LAYER_LIST;
	}	
	virtual int GetItemType(int nRow)
	{
		string strType;
		strType =GetCell(nRow,PELAYER_TYPE);
		if(strType.IsEmpty())
			return ITEM_IS_NULL;
		
		if(strType.CompareNoCase(_L("Folder")) == 0)
			return ITEM_IS_FOLDER;
			
		return ITEM_IS_LAYER;
	}
	virtual void GetBrowserSupportTypeList(vector<int> &vnList)
	{
		vector<int> vnTypeLit = {EXIST_WKS, EXIST_GRAPH, EXIST_MATRIX, EXIST_NONE};
		vnList = vnTypeLit;
	}
	///Sophy CLEAN_CODE_PBLIST_CONTROL
	/*
	///Jasmine 12/25/06 SHOW_PAGE_OR_LAYER
	virtual bool UpdateList(TreeNode trNode, int nShowItemType = 0)
	{
		if(!trNode.IsValid())
			return false;
		
		string strPath;
		trNode.GetAttribute(STR_PATH_ATTRIB, strPath);	
		
		Folder fldr(strPath);		
		//----- Iris 12/22/2006 CHOOSE_PAGE_IN_LEFT_SHOULD_SHOW_LAYER_IN_RIGHT_PANEL
			//return UpdateList(fldr , nShowItemType);
		if(fldr)
			return UpdateList(fldr , nShowItemType);
		
		string 	strName;
		trNode.GetAttribute(STR_LABEL_ATTRIB, strName);
		Page	pg(strName);
		if(pg)
			return UpdateList(pg, nShowItemType);
		string strPage;
		okutil_get_book_sheet_names(strName, &strPage, &strName); 
		Page pgTemp(strPage);
		Layer lay = pgTemp.Layers(strName);
		if(lay)
			UpdateList(lay);
		
		return false;
		//-----
	}
	///End SHOW_PAGE_OR_LAYER
	*/
	//virtual
	bool	GetItems( TreeNode& trNode, 
					vector<string>& vsItems, vector<int>& vnPageType, 
					vector<DWORD>& vdwStatus,//vector<bool>& vbHideGray, ///Jasmine 04/27/10 QA81-14826-P5 COMBINE_BOOL_IN_DWORD_TO_SIMPLIFY_FUNC_INTERFACE
					int nShowItemType = 0,
					bool bIncludeShortcut = false)	///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
	{
		if( !trNode.IsValid() )
			return false;
		string strPath;
		trNode.GetAttribute(STR_PATH_ATTRIB, strPath);	
		
		Folder fldr(strPath);		
		if(fldr)
		{
			bool bRet = GetItems( fldr, 
								vsItems, vnPageType, vdwStatus, 
								nShowItemType, false,
								bIncludeShortcut);	///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
			return bRet;
		}
		
		string 	strName;
		trNode.GetAttribute(STR_LABEL_ATTRIB, strName);
		Page	pg(strName);
		if(pg)
			return GetItems( pg, vsItems, vnPageType, vdwStatus, nShowItemType);
		
		string strPage;
		okutil_get_book_sheet_names(strName, &strPage, &strName); 
		Page pgTemp(strPage);
		Layer lay = pgTemp.Layers(strName);
		if(lay)
			return GetItems( lay, vsItems ,vnPageType, vdwStatus );
		
		return false;
	}
	///end Sophy CLEAN_CODE_PBLIST_CONTROL
	
	///Folger 06/20/07 CREATE_GET_INIT_RANGE_STRING
	//--------Folger 07/03/07 CLEAN_UP_GET_RANGE_STRING_CODE
	//virtual bool GetInitRangeString(vector<string> &vsVals)
	virtual int GetInitRangeString(vector<string> &vsVals)
	//--------end CLEAN_UP_GET_RANGE_STRING_CODE
	{
		string strPage;
		Page pg = Project.ActiveLayer().GetPage();
		if(pg)
			pg.GetRangeString(strPage);
		int nCount = vsVals.GetSize();
		for(int ii = 0; ii < nCount; ii++)
		{
			string str = vsVals[ii];
			str.TrimLeft(); str.TrimRight();
			Worksheet wks(str);
			if (!wks)
			{
				str = strPage + str;
				Worksheet wksTmp(str);
				wks = wksTmp;
			}
			vsVals[ii] = wks ? str : "";
		}
		//--------Folger 07/03/07 CLEAN_UP_GET_RANGE_STRING_CODE
		//return true;
		return vsVals.GetSize();
		//--------end CLEAN_UP_GET_RANGE_STRING_CODE
	}
	///End CREATE_GET_INIT_RANGE_STRING
	virtual string GetRuntimeClass()
	{
		return "PBLayerList";
	}
protected:
	//------ Folger 08/03/07 ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
	//virtual	bool AddItems(PageBase &pb)
	virtual bool AddItems(PageBase &pb, 
						vector<string> &vsRows, vector<int> &vnPageType, 
						vector<DWORD>& vdwStatus,//vector<bool> &vbHideGray)	///Jasmine 04/27/10 QA81-14826-P5 COMBINE_BOOL_IN_DWORD_TO_SIMPLIFY_FUNC_INTERFACE
						const Folder& fldParent = NULL)	///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
	//------ End ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
	{
		if(!pb)
			return false;
		
		/// TD 8-3-06 QA70-8843 DOWNCAST_BUG
		//int nLayers = numOfLayers(pb);
		Page page = pb;
		int nLayers = numOfLayers(page);
		/// end DOWNCAST_BUG
		Page* ppb;
		switch(pb.GetType())
		{
		case EXIST_WKS:
			ppb = new WorksheetPage(pb);
			break;
		case EXIST_PLOT:
			ppb = new GraphPage(pb);
			break;
		case EXIST_MATRIX:
			ppb = new MatrixPage(pb);
			break;
		default:
			return true;
		}
		//------ Folger 08/03/07 ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
		int nPageType = ppb->GetType();
		bool bHideGray = ppb->GetShow() == PAGE_HIDDEN;
		DWORD dwStatus = bHideGray? PAGE_STATUS_HIDDEN : 0;	///Jasmine 04/27/10 QA81-14826-P5 COMBINE_BOOL_IN_DWORD_TO_SIMPLIFY_FUNC_INTERFACE
		//------ End ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
		for(int ii = 0; ii < nLayers; ii++)
		{
			Layer lay = ppb->Layers(ii);
	///Jasmine 12/25/06 SHOW_PAGE_OR_LAYER
			//------ Folger 08/03/07 ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
			//AddItems(lay);
			///Jasmine 09/28/07 FILTER_OUT_NON_IMAGE_MATRIX	
			//if(wks && !m_bResultSheet && (wks.GetSystemParam(0) & WP_SHEET_HIERARCHY))
			if(EXIST_WKS == nPageType && (m_dwFilter & SCD_NO_RESULT_SHEET))
			{
				Worksheet wks(lay);
				if(wks && (wks.GetSystemParam(0) & WP_SHEET_HIERARCHY))
					continue;
			}
			///End FILTER_OUT_NON_IMAGE_MATRIX
			vsRows.Add(MakeRow(lay));
			vnPageType.Add(nPageType);
			vdwStatus.Add(dwStatus);
			//------ End ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
		}
		return true;
	}
	//------ Folger 08/03/07 ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
	//virtual	bool AddItems(Layer &lay)
	//{		
		//Worksheet wks(lay);	///Jasmine 07/17/07 EXCLUDE_RESULT_SHEET
		//if(wks && !m_bResultSheet && (wks.GetSystemParam(0) & WP_SHEET_HIERARCHY))
			//return true;
		//string strItem = MakeRow(lay);
		//m_flx.AddItem(strItem);
		////SetCellIcon(m_flx.Rows - 1, 0, GetDisplayId(pb.GetType()), MODULE_ORIGIN);//TD 3-30-04
		//Page pg = lay.GetPage();
		//SetCellIcon(m_flx.Rows - 1, 0, get_page_display_id(pg.GetType()), MODULE_ORIGIN);//TD 3-30-04
		//if(pg.GetShow() == PAGE_HIDDEN)
			//SetHideGray(m_flx.Rows-1, 0);
		//return true;
	//}
	///End SHOW_PAGE_OR_LAYER
	//------ End ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
	virtual string GetSeletedItemName(int nRow, bool bIncludeFolder = false)
	{
		string strSeletedName;
		//if(GetItemType(nRow, PELAYER_TYPE) != ITEM_IS_LAYER || nRow == 0)
		//if(GetItemType(nRow) != ITEM_IS_LAYER || nRow == 0)
		if((GetItemType(nRow) != ITEM_IS_LAYER && !bIncludeFolder) || nRow == 0)
			return "";
		
		strSeletedName = GetCell(flexcpText, nRow, PELAYER_NAME);
		return strSeletedName;
	}
	virtual string MakeCol(OriginObject &obj, int nColType)
	{
		/// TD 8-3-06 QA70-8843 DOWNCAST_BUG
		//Layer lay(obj);
		Layer lay;
		lay= obj;
		/// end DOWNCAST_BUG
		string strTemp;
		switch(nColType)
		{
		case PELAYER_NAME:
			return getLayerShowName(lay);
		case PELAYER_TYPE:
			return getLayerTypeName(lay.GetPage().GetType());
		case PELAYER_SIZE:
			return getLayerSize(lay);
		case PELAYER_VIEW:
			return GetPageShowState(lay.GetPage().GetShow());
		case PELAYER_FILENAME:
			return getLayerImportFileInfo(lay);
		default:
			break;
		}
		
		return strTemp;// return empty
	}
	virtual string MakeFolderCol(Folder &fld, int nColType)
	{
		string strTemp;
		switch(nColType)
		{
		case PELAYER_NAME:
			return fld.GetName();
		case PELAYER_TYPE:
			return _L("Folder");
		case PELAYER_SIZE:
		case PELAYER_VIEW:
		case PELAYER_FILENAME:
		default:
			strTemp = "";
			break;
		}
		return strTemp;
	}
private:
	//Return the layer import info, now return the import file name .
	string getLayerImportFileInfo(Layer &lay)
	{
		string strLayerImportFiles;
		Tree tr;
		//------ Folger 07/27/07 FIX_BUGS_IN_DISPLAY_IMPORT_FILE_NAME
		//string strLayerConfigName = "[" + lay.GetPage().GetName() + "]" + lay.GetName()+ "!*";
		string strLayerConfigName = lay.GetName();
		okutil_check_add_quotes(strLayerConfigName);
		strLayerConfigName += "!*";
		//------ End FIX_BUGS_IN_DISPLAY_IMPORT_FILE_NAME
		Tree trInfo;
		if(tree_get_binary_storage(trInfo,lay.GetPage(), IFI_BINARY_STORAGE_NAME))
		{
			TreeNode trImportFiles = tr.AddNode("ImportedFiles");
			string str;
			for(int n=1; ; n++)
			{
				str.Format(IFI_FILE_NODE_ENUM_NAME, n);
				TreeNode trn = trInfo.GetNode(str);

				if(trn)
				{					
					if(lay.GetPage().GetType() == EXIST_WKS)
					{
						//------ Folger 07/14/08 QA80-11840 FIX_RUNTIME_ERROR_FOR_SOME_SPECIAL_IMPORT_DATA
						////------ Folger 07/27/07 FIX_BUGS_IN_DISPLAY_IMPORT_FILE_NAME
						////string strRange = trn.Info.DataRange.Range.strVal;
						//string strRange = trn.Info.DataRange.strVal;
						////------ End FIX_BUGS_IN_DISPLAY_IMPORT_FILE_NAME
						//if(strRange.Match(strLayerConfigName))
						TreeNode trRange = trn.Info.DataRange;
						if ( trRange && trRange.strVal.Match(strLayerConfigName) )
						//------ End FIX_RUNTIME_ERROR_FOR_SOME_SPECIAL_IMPORT_DATA
						{
							if(!strLayerImportFiles.IsEmpty())
								strLayerImportFiles += " || ";

							strLayerImportFiles += trn.Info.FilePath.strVal;						
							trImportFiles.AddNode(trn);
						}
					}
					else
						if(lay.GetPage().GetType() == EXIST_GRAPH || lay.GetPage().GetType() == EXIST_MATRIX)
						{
							if(!strLayerImportFiles.IsEmpty())
								strLayerImportFiles += " || ";
							strLayerImportFiles += trn.Info.FilePath.strVal;						
						}
					//TreeNode trFile=tree_check_get_node(trImportFiles, "File", n, trn.Info.FileName.strVal, "ddd");
				}
				else
					break;			
			}
		}
		return strLayerImportFiles;
	}
	///return the layer name as [PageName]LayerName
	string getLayerShowName(Layer &lay)
	{
		if(!lay)
			return "";
		string strShowName ; 
		strShowName = make_book_sheet_name(lay.GetPage().GetName(),  lay.GetName());
		//strShowName ="["  + lay.GetPage().GetName()+ "]" + lay.GetName(); 
		return strShowName;
	}
	///Return the num of the layers in the page.
	UINT numOfLayers(Page &pb)
	{
		if(!pb)
			return -1; //Change 0 to -1 mean not a valid page
		UINT nLayers;
		switch(pb.GetType())
		{
		case EXIST_NOTES:
		case EXIST_LAYOUT:
			return 0;	//Change 1 to 0 mean not just one layer, if use 1 will confuse with worksheetpage with one layer
		case EXIST_WKS:
		case EXIST_EXTERN_WKS:
			WorksheetPage wks(pb);
			nLayers = wks.Layers.Count();
			break;
		case EXIST_MATRIX:
			MatrixPage mat(pb);
			nLayers = mat.Layers.Count();
			break;
		case EXIST_GRAPH:
			GraphPage gp(pb);
			nLayers = gp.Layers.Count();
			break;
		default:
			break:
		};	
		return nLayers;
	}
	string getLayerTypeName(int nPageType)
	{
		switch(nPageType)
		{
		case EXIST_GRAPH:
			return _L("GraphLayer");
		case EXIST_WKS:
			return _L("Worksheet");
		case EXIST_NOTES:
			return _L("Note");
		case EXIST_EXTERN_WKS:
			return _L("Worksheet");
		case EXIST_MATRIX:
			return _L("MatrixLayer");
		case EXIST_LAYOUT:
			return _L("Layout");
		default:
			break:
		};
		return _L("Folder");
	}	
	///If the layer is worksheet and matrixlayer, return the layer's size as format col:Rows; if a graph, return the plot count.
	string getLayerSize(Layer &lay)
	{
		string strSize ;
		switch(lay.GetPage().GetType())
		{
		case EXIST_WKS:
		case EXIST_EXTERN_WKS:
		case EXIST_MATRIX:
			Datasheet ds(lay);
		///Kyle 07/15/08 QA80-11840 CHANGE_THE_SIZE_DISPLAY_FORMAT
		//	strSize = (string) ds.GetNumCols() + ":" + (string)ds.GetNumRows();
			strSize = (string) ds.GetNumCols() + "x" + (string)ds.GetNumRows();
		///End CHANGE_THE_SIZE_DISPLAY_FORMAT
			break;
		case EXIST_GRAPH:
			GraphLayer gl(lay);
			strSize = (string)gl.DataPlots.Count();
			break;
		default:
			strSize = "";
			break:
		};
		return strSize;			
	}

};
